/*
 * Copyright (C) 2010, Panasonic Corporation.
 *                       All Rights Reserved.
 *
 */

#if defined(CONFIG_USB_PANASONIC_TEST_MODE_IN_USB_DRIVER)

#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/usb.h>
#include <linux/usb/quirks.h>
#include "usb.h"
#include "hcd.h"
#include "../host/ehci-test.h"

static int (*pf_usb_test_mode)( struct usb_device* udev, u32 testid, enum usb_device_speed speed );

static void print_usage(void)
{
	printk( "please specify 2 parameters by hex.\n"
			"param1 is test-id   (101 - 108)\n"
			"param2 is test-speed(1 - 3)\n\n"
			"test-id\n"
			"  VAL  : TEST\n"
			"  %4X  : SE0\n"
			"  %4X  : J\n"
			"  %4X  : K\n"
			"  %4X  : PACKET\n"
			"  %4X  : SUSRUM\n"
			"  %4X  : GETDEV\n"
			"  %4X  : SETFEA\n\n"
			"test-speed\n"
			"  VAL : SPEED\n"
			"  1   : low\n"
			"  2   : full\n"
			"  3   : high\n",
			USB_TESTMD_PID_SE0,
			USB_TESTMD_PID_J,
			USB_TESTMD_PID_K,
			USB_TESTMD_PID_PACKET,
			USB_TESTMD_PID_SUSRUM,
			USB_TESTMD_PID_GETDEV,
			USB_TESTMD_PID_SETFEA
		);
}

static ssize_t set_host_test_mode(struct device *dev, struct device_attribute *attr, const char *buf, size_t count)
{
	struct usb_device* udev;
	u32 testid, testspeed;
	enum usb_device_speed speed;
	int ret;
	
	udev = to_usb_device(dev);
	
	if( !pf_usb_test_mode ){
		printk( "please insmod usb-test-mode.ko\n" );
		return -EINVAL;
	}
	
	ret = sscanf( buf, "%x %x", &testid, &testspeed );
	if( ret != 2 ){
		print_usage();
		return -EINVAL;
	}
	
	switch( testspeed ){
		case 1:		speed = USB_SPEED_LOW;	break;
		case 2:		speed = USB_SPEED_FULL;	break;
		case 3:		speed = USB_SPEED_HIGH;	break;
		default:
			print_usage();
			return -EINVAL;
	}
	
	ret = pf_usb_test_mode( udev, testid, speed );
	if( ret < 0 ){
		print_usage();
		return ret;
	}
	
	return count;
}
static DEVICE_ATTR( host_test_mode, S_IWUSR, NULL, set_host_test_mode );

static struct attribute *dev_host_test_mode_attrs[] = {
	&dev_attr_host_test_mode.attr,
	NULL
};

const struct attribute_group dev_host_test_mode_attr_grp = {
	.attrs =		dev_host_test_mode_attrs,

};

void usb_set_host_test_function( int (*func)( struct usb_device* udev, u32 testid, enum usb_device_speed speed ) )
{
	pf_usb_test_mode = func;
}
EXPORT_SYMBOL_GPL( usb_set_host_test_function );

#endif

